mode = ADF_ADF
receiver_mode = ADF_RECEIVER_TLF
homer_selection_method = ADF_HOMER_SELECTION_AUTO
channel = 1
volume = 0.5

channels = {
	[1] = runway_homer_pair(Airdrome[Krasnodar],nil,localizedAirdromeName(terrainAirdromes[Krasnodar])),
	[2] = runway_homer_pair(Airdrome[Maykop]   ,nil,localizedAirdromeName(terrainAirdromes[Maykop])),
	[3] = runway_homer_pair(Airdrome[Krymsk]   ,nil,localizedAirdromeName(terrainAirdromes[Krymsk])),
	[4] = runway_homer_pair(Airdrome[Anapa]    ,nil,localizedAirdromeName(terrainAirdromes[Anapa])),
	[5] = runway_homer_pair(Airdrome[Mozdok]   ,nil,localizedAirdromeName(terrainAirdromes[Mozdok])),
	[6] = runway_homer_pair(Airdrome[Nalchick] ,nil,localizedAirdromeName(terrainAirdromes[Nalchick])),
	[7] = runway_homer_pair(Airdrome[MinVody]  ,nil,localizedAirdromeName(terrainAirdromes[MinVody])),
	[8] = {
		[ADF_HOMER_FAR] = NDB(beacons["Кисловодск"]),
		[ADF_HOMER_NEAR] = NDB(beacons["Передовая"])
	}
}

function RUNWAY_HOMER_BY_FREQ(freq, homer_type) 
	local homer_data = nil

	for ia, a in pairs(Airdrome) do
		if a.runway then
			for ir, r in pairs(a.runway) do
				for irs, rs in pairs(r.side) do
					for ih, h in pairs(rs) do
						-- runway homer (ILS)
						if h.frequency == freq then	
							if h.type == homer_type then
								if homer_data == nil then
									homer_data = {							
										airdrome_id = ia, --a.id,
										name = localizedAirdromeName(terrainAirdromes[ia]),
										frequency = h.frequency,
										callsign = ''}
								end
								if string.len(homer_data.callsign) > 0 then
									homer_data.callsign = homer_data.callsign..','
								end
								homer_data.callsign = homer_data.callsign..h.callsign	
							end
						end
					end
				end
			end
		end
	end
	
	return homer_data
end

function AIRDROME_HOMER_BY_FREQ(freq) 
	local homer_data = nil
	
	for ia, a in pairs(Airdrome) do
		if a.airdrome then
			-- general airdrome homer
			for ih, h in pairs(a.airdrome) do
				if h.frequency == freq then	
					if h.type == BEACON_TYPE_AIRPORT_HOMER_WITH_MARKER or
					   h.type == BEACON_TYPE_AIRPORT_HOMER then
						if homer_data == nil then
							homer_data = {							
								airdrome_id = ia, --a.id,
								name = localizedAirdromeName(terrainAirdromes[ia]),
								frequency = h.frequency,
								callsign = ''}
						end
						if string.len(homer_data.callsign) > 0 then
							homer_data.callsign = homer_data.callsign..','
						end
						homer_data.callsign = homer_data.callsign..h.callsign	
					end
				end		
			end
		end
	end
	
	return homer_data
end

function NDB_BY_FREQ(freq)
	local homer = nil
	
	for ih, h in pairs(beacons) do
		if h.frequency == freq then
			homer = h
			break
		end
	end
	
	return homer
end

function FIND_HOMER(freq, primary_beacon_type)
	local homer = nil
	local placard_type = ''
	
	-- first attempt: homer with a given freq and type
	homer = RUNWAY_HOMER_BY_FREQ(freq, primary_beacon_type) -- BEACON_TYPE_ILS_FAR_HOMER or BEACON_TYPE_ILS_NEAR_HOMER
	--[[if primary_beacon_type == BEACON_TYPE_ILS_FAR_HOMER then
		placard_type = 'O'
	else
		placard_type = 'I'
	end	--]]
	if not homer then
		-- second attempt: airdrome homer with a given freq
		homer = AIRDROME_HOMER_BY_FREQ(freq)
		placard_type = '* '
		if not homer then
			-- third attempt: NDB with a given freq
			homer = NDB_BY_FREQ(freq)
			placard_type = '* '
			if not homer then
				-- fall back: just listing the frequeny
				homer = {	name = freq/1e3.." KHz",
							callsign =  "",
							frequency = freq }
				placard_type = '* '
			end
		end
	end

	homer.name = placard_type..homer.name
	
	return homer 
	
	-- Doh! (scnr)
end

if get_aircraft_mission_data ~= nil then
	local radio_from_mission = get_aircraft_mission_data("Radio")
	local radio_2 = radio_from_mission[2]
	
	if radio_2 then
		for i = 1,8 do
			channels[i] = { [ADF_HOMER_FAR]  = FIND_HOMER(radio_2.channels[i*2-1] * 1e6, BEACON_TYPE_ILS_FAR_HOMER),
							[ADF_HOMER_NEAR] = FIND_HOMER(radio_2.channels[i*2]   * 1e6, BEACON_TYPE_ILS_NEAR_HOMER) }
			 
--print("ME definition: "..radio_2.channels[i*2-1].."/"..radio_2.channels[i*2])
--print("   ARK preset: "..channels[i][ADF_HOMER_FAR].frequency.."/"..channels[i][ADF_HOMER_NEAR].frequency)
		end
	end
end

